/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse;

public class ListRulesPackagesIterable
implements SdkIterable<ListRulesPackagesResponse> {
    private final InspectorClient client;
    private final ListRulesPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRulesPackagesIterable(InspectorClient client, ListRulesPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRulesPackagesResponseFetcher();
    }

    public Iterator<ListRulesPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRulesPackagesResponseFetcher
    implements SyncPageFetcher<ListRulesPackagesResponse> {
        private ListRulesPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListRulesPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRulesPackagesResponse nextPage(ListRulesPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListRulesPackagesIterable.this.client.listRulesPackages(ListRulesPackagesIterable.this.firstRequest);
            }
            return ListRulesPackagesIterable.this.client.listRulesPackages((ListRulesPackagesRequest)((Object)ListRulesPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

