/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse;

public class ListAssessmentRunsPublisher
implements SdkPublisher<ListAssessmentRunsResponse> {
    private final InspectorAsyncClient client;
    private final ListAssessmentRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentRunsPublisher(InspectorAsyncClient client, ListAssessmentRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentRunsPublisher(InspectorAsyncClient client, ListAssessmentRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentRunsResponseFetcher
    implements AsyncPageFetcher<ListAssessmentRunsResponse> {
        private ListAssessmentRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentRunsResponse> nextPage(ListAssessmentRunsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentRunsPublisher.this.client.listAssessmentRuns(ListAssessmentRunsPublisher.this.firstRequest);
            }
            return ListAssessmentRunsPublisher.this.client.listAssessmentRuns((ListAssessmentRunsRequest)((Object)ListAssessmentRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

