/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse;

public class ListAssessmentRunsIterable
implements SdkIterable<ListAssessmentRunsResponse> {
    private final InspectorClient client;
    private final ListAssessmentRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssessmentRunsIterable(InspectorClient client, ListAssessmentRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssessmentRunsResponseFetcher();
    }

    public Iterator<ListAssessmentRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssessmentRunsResponseFetcher
    implements SyncPageFetcher<ListAssessmentRunsResponse> {
        private ListAssessmentRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssessmentRunsResponse nextPage(ListAssessmentRunsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentRunsIterable.this.client.listAssessmentRuns(ListAssessmentRunsIterable.this.firstRequest);
            }
            return ListAssessmentRunsIterable.this.client.listAssessmentRuns((ListAssessmentRunsRequest)((Object)ListAssessmentRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

