/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model._roleListTypeCopier;
import software.amazon.awssdk.services.iam.model._tagListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceProfile> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(InstanceProfile.getter(InstanceProfile::path)).setter(InstanceProfile.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileName").getter(InstanceProfile.getter(InstanceProfile::instanceProfileName)).setter(InstanceProfile.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileId").getter(InstanceProfile.getter(InstanceProfile::instanceProfileId)).setter(InstanceProfile.setter(Builder::instanceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(InstanceProfile.getter(InstanceProfile::arn)).setter(InstanceProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(InstanceProfile.getter(InstanceProfile::createDate)).setter(InstanceProfile.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<List<Role>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Roles").getter(InstanceProfile.getter(InstanceProfile::roles)).setter(InstanceProfile.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(InstanceProfile.getter(InstanceProfile::tags)).setter(InstanceProfile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, INSTANCE_PROFILE_NAME_FIELD, INSTANCE_PROFILE_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, ROLES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String instanceProfileName;
    private final String instanceProfileId;
    private final String arn;
    private final Instant createDate;
    private final List<Role> roles;
    private final List<Tag> tags;

    private InstanceProfile(BuilderImpl builder) {
        this.path = builder.path;
        this.instanceProfileName = builder.instanceProfileName;
        this.instanceProfileId = builder.instanceProfileId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.roles = builder.roles;
        this.tags = builder.tags;
    }

    public final String path() {
        return this.path;
    }

    public final String instanceProfileName() {
        return this.instanceProfileName;
    }

    public final String instanceProfileId() {
        return this.instanceProfileId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public final List<Role> roles() {
        return this.roles;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProfile)) {
            return false;
        }
        InstanceProfile other = (InstanceProfile)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.instanceProfileId(), other.instanceProfileId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceProfile").add("Path", (Object)this.path()).add("InstanceProfileName", (Object)this.instanceProfileName()).add("InstanceProfileId", (Object)this.instanceProfileId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("Roles", this.hasRoles() ? this.roles() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "InstanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "InstanceProfileId": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "Roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceProfile, T> g) {
        return obj -> g.apply((InstanceProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String instanceProfileName;
        private String instanceProfileId;
        private String arn;
        private Instant createDate;
        private List<Role> roles = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProfile model) {
            this.path(model.path);
            this.instanceProfileName(model.instanceProfileName);
            this.instanceProfileId(model.instanceProfileId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.roles(model.roles);
            this.tags(model.tags);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        public final String getInstanceProfileId() {
            return this.instanceProfileId;
        }

        @Override
        public final Builder instanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
            return this;
        }

        public final void setInstanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final List<Role.Builder> getRoles() {
            List<Role.Builder> result = _roleListTypeCopier.copyToBuilder(this.roles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = _roleListTypeCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = _roleListTypeCopier.copyFromBuilder(roles);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        public InstanceProfile build() {
            return new InstanceProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceProfile> {
        public Builder path(String var1);

        public Builder instanceProfileName(String var1);

        public Builder instanceProfileId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);

        public Builder roles(Consumer<Role.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

