/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventAggregate;
import software.amazon.awssdk.services.health.model.EventAggregateListCopier;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventAggregatesResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEventAggregatesResponse> {
    private static final SdkField<List<EventAggregate>> EVENT_AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventAggregates").getter(DescribeEventAggregatesResponse.getter(DescribeEventAggregatesResponse::eventAggregates)).setter(DescribeEventAggregatesResponse.setter(Builder::eventAggregates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventAggregates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventAggregate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeEventAggregatesResponse.getter(DescribeEventAggregatesResponse::nextToken)).setter(DescribeEventAggregatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_AGGREGATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<EventAggregate> eventAggregates;
    private final String nextToken;

    private DescribeEventAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.eventAggregates = builder.eventAggregates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventAggregates() {
        return this.eventAggregates != null && !(this.eventAggregates instanceof SdkAutoConstructList);
    }

    public final List<EventAggregate> eventAggregates() {
        return this.eventAggregates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventAggregates() ? this.eventAggregates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesResponse)) {
            return false;
        }
        DescribeEventAggregatesResponse other = (DescribeEventAggregatesResponse)((Object)obj);
        return this.hasEventAggregates() == other.hasEventAggregates() && Objects.equals(this.eventAggregates(), other.eventAggregates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventAggregatesResponse").add("EventAggregates", this.hasEventAggregates() ? this.eventAggregates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventAggregates": {
                return Optional.ofNullable(clazz.cast(this.eventAggregates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventAggregatesResponse, T> g) {
        return obj -> g.apply((DescribeEventAggregatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<EventAggregate> eventAggregates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesResponse model) {
            super(model);
            this.eventAggregates(model.eventAggregates);
            this.nextToken(model.nextToken);
        }

        public final List<EventAggregate.Builder> getEventAggregates() {
            List<EventAggregate.Builder> result = EventAggregateListCopier.copyToBuilder(this.eventAggregates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder eventAggregates(Collection<EventAggregate> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copy(eventAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventAggregates(EventAggregate ... eventAggregates) {
            this.eventAggregates(Arrays.asList(eventAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventAggregates(Consumer<EventAggregate.Builder> ... eventAggregates) {
            this.eventAggregates(Stream.of(eventAggregates).map(c -> (EventAggregate)((EventAggregate.Builder)EventAggregate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventAggregates(Collection<EventAggregate.BuilderImpl> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copyFromBuilder(eventAggregates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEventAggregatesResponse build() {
            return new DescribeEventAggregatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventAggregatesResponse> {
        public Builder eventAggregates(Collection<EventAggregate> var1);

        public Builder eventAggregates(EventAggregate ... var1);

        public Builder eventAggregates(Consumer<EventAggregate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

