/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, CreateConfigResponse> {
    private static final SdkField<String> CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configArn").getter(CreateConfigResponse.getter(CreateConfigResponse::configArn)).setter(CreateConfigResponse.setter(Builder::configArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configArn").build()}).build();
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configId").getter(CreateConfigResponse.getter(CreateConfigResponse::configId)).setter(CreateConfigResponse.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()}).build();
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configType").getter(CreateConfigResponse.getter(CreateConfigResponse::configTypeAsString)).setter(CreateConfigResponse.setter(Builder::configType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ARN_FIELD, CONFIG_ID_FIELD, CONFIG_TYPE_FIELD));
    private final String configArn;
    private final String configId;
    private final String configType;

    private CreateConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configArn = builder.configArn;
        this.configId = builder.configId;
        this.configType = builder.configType;
    }

    public final String configArn() {
        return this.configArn;
    }

    public final String configId() {
        return this.configId;
    }

    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(this.configType);
    }

    public final String configTypeAsString() {
        return this.configType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigResponse)) {
            return false;
        }
        CreateConfigResponse other = (CreateConfigResponse)((Object)obj);
        return Objects.equals(this.configArn(), other.configArn()) && Objects.equals(this.configId(), other.configId()) && Objects.equals(this.configTypeAsString(), other.configTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfigResponse").add("ConfigArn", (Object)this.configArn()).add("ConfigId", (Object)this.configId()).add("ConfigType", (Object)this.configTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configArn": {
                return Optional.ofNullable(clazz.cast(this.configArn()));
            }
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "configType": {
                return Optional.ofNullable(clazz.cast(this.configTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigResponse, T> g) {
        return obj -> g.apply((CreateConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String configArn;
        private String configId;
        private String configType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigResponse model) {
            super(model);
            this.configArn(model.configArn);
            this.configId(model.configId);
            this.configType(model.configType);
        }

        public final String getConfigArn() {
            return this.configArn;
        }

        @Override
        public final Builder configArn(String configArn) {
            this.configArn = configArn;
            return this;
        }

        public final void setConfigArn(String configArn) {
            this.configArn = configArn;
        }

        public final String getConfigId() {
            return this.configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        public final String getConfigType() {
            return this.configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public CreateConfigResponse build() {
            return new CreateConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigResponse> {
        public Builder configArn(String var1);

        public Builder configId(String var1);

        public Builder configType(String var1);

        public Builder configType(ConfigCapabilityType var1);
    }
}

