/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentVersionListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentVersionListItem> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ComponentVersionListItem.getter(ComponentVersionListItem::componentName)).setter(ComponentVersionListItem.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(ComponentVersionListItem.getter(ComponentVersionListItem::componentVersion)).setter(ComponentVersionListItem.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ComponentVersionListItem.getter(ComponentVersionListItem::arn)).setter(ComponentVersionListItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String componentVersion;
    private final String arn;

    private ComponentVersionListItem(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.arn = builder.arn;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVersionListItem)) {
            return false;
        }
        ComponentVersionListItem other = (ComponentVersionListItem)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentVersionListItem").add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentVersionListItem, T> g) {
        return obj -> g.apply((ComponentVersionListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String componentVersion;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentVersionListItem model) {
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.arn(model.arn);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public ComponentVersionListItem build() {
            return new ComponentVersionListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentVersionListItem> {
        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder arn(String var1);
    }
}

