/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComponentDependencyType {
    HARD("HARD"),
    SOFT("SOFT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ComponentDependencyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComponentDependencyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ComponentDependencyType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComponentDependencyType> knownValues() {
        return Stream.of(ComponentDependencyType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

