/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.DefinitionInformation;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.___listOfDefinitionInformationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceDefinitionsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListResourceDefinitionsResponse> {
    private static final SdkField<List<DefinitionInformation>> DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Definitions").getter(ListResourceDefinitionsResponse.getter(ListResourceDefinitionsResponse::definitions)).setter(ListResourceDefinitionsResponse.setter(Builder::definitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DefinitionInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceDefinitionsResponse.getter(ListResourceDefinitionsResponse::nextToken)).setter(ListResourceDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DefinitionInformation> definitions;
    private final String nextToken;

    private ListResourceDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.definitions = builder.definitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDefinitions() {
        return this.definitions != null && !(this.definitions instanceof SdkAutoConstructList);
    }

    public final List<DefinitionInformation> definitions() {
        return this.definitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefinitions() ? this.definitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceDefinitionsResponse)) {
            return false;
        }
        ListResourceDefinitionsResponse other = (ListResourceDefinitionsResponse)((Object)obj);
        return this.hasDefinitions() == other.hasDefinitions() && Objects.equals(this.definitions(), other.definitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceDefinitionsResponse").add("Definitions", this.hasDefinitions() ? this.definitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Definitions": {
                return Optional.ofNullable(clazz.cast(this.definitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceDefinitionsResponse, T> g) {
        return obj -> g.apply((ListResourceDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private List<DefinitionInformation> definitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceDefinitionsResponse model) {
            super(model);
            this.definitions(model.definitions);
            this.nextToken(model.nextToken);
        }

        public final List<DefinitionInformation.Builder> getDefinitions() {
            List<DefinitionInformation.Builder> result = ___listOfDefinitionInformationCopier.copyToBuilder(this.definitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder definitions(Collection<DefinitionInformation> definitions) {
            this.definitions = ___listOfDefinitionInformationCopier.copy(definitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(DefinitionInformation ... definitions) {
            this.definitions(Arrays.asList(definitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(Consumer<DefinitionInformation.Builder> ... definitions) {
            this.definitions(Stream.of(definitions).map(c -> (DefinitionInformation)((DefinitionInformation.Builder)DefinitionInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDefinitions(Collection<DefinitionInformation.BuilderImpl> definitions) {
            this.definitions = ___listOfDefinitionInformationCopier.copyFromBuilder(definitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceDefinitionsResponse build() {
            return new ListResourceDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceDefinitionsResponse> {
        public Builder definitions(Collection<DefinitionInformation> var1);

        public Builder definitions(DefinitionInformation ... var1);

        public Builder definitions(Consumer<DefinitionInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

