/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CrawlState {
    RUNNING("RUNNING"),
    CANCELLING("CANCELLING"),
    CANCELLED("CANCELLED"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CrawlState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CrawlState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CrawlState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CrawlState> knownValues() {
        return Stream.of(CrawlState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

