/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Type {
    AMAZON_CUSTOMER_BY_EMAIL("AmazonCustomerByEmail"),
    CANONICAL_USER("CanonicalUser"),
    GROUP("Group"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Type fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Type.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Type> knownValues() {
        return Stream.of(Type.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

