/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.ListFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetsResponse;

public class ListFleetsIterable
implements SdkIterable<ListFleetsResponse> {
    private final GameLiftClient client;
    private final ListFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFleetsIterable(GameLiftClient client, ListFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFleetsResponseFetcher();
    }

    public Iterator<ListFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> fleetIds() {
        Function<ListFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetIds() != null) {
                return response.fleetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFleetsResponseFetcher
    implements SyncPageFetcher<ListFleetsResponse> {
        private ListFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFleetsResponse nextPage(ListFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetsIterable.this.client.listFleets(ListFleetsIterable.this.firstRequest);
            }
            return ListFleetsIterable.this.client.listFleets((ListFleetsRequest)((Object)ListFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

