/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse;

public class DescribeDataRepositoryTasksPublisher
implements SdkPublisher<DescribeDataRepositoryTasksResponse> {
    private final FSxAsyncClient client;
    private final DescribeDataRepositoryTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataRepositoryTasksPublisher(FSxAsyncClient client, DescribeDataRepositoryTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataRepositoryTasksPublisher(FSxAsyncClient client, DescribeDataRepositoryTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataRepositoryTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataRepositoryTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeDataRepositoryTasksResponseFetcher
    implements AsyncPageFetcher<DescribeDataRepositoryTasksResponse> {
        private DescribeDataRepositoryTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataRepositoryTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDataRepositoryTasksResponse> nextPage(DescribeDataRepositoryTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataRepositoryTasksPublisher.this.client.describeDataRepositoryTasks(DescribeDataRepositoryTasksPublisher.this.firstRequest);
            }
            return DescribeDataRepositoryTasksPublisher.this.client.describeDataRepositoryTasks((DescribeDataRepositoryTasksRequest)((Object)DescribeDataRepositoryTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

