/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemWindowsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, UpdateFileSystemRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(UpdateFileSystemRequest.getter(UpdateFileSystemRequest::fileSystemId)).setter(UpdateFileSystemRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(UpdateFileSystemRequest.getter(UpdateFileSystemRequest::clientRequestToken)).setter(UpdateFileSystemRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacity").getter(UpdateFileSystemRequest.getter(UpdateFileSystemRequest::storageCapacity)).setter(UpdateFileSystemRequest.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()}).build();
    private static final SdkField<UpdateFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WindowsConfiguration").getter(UpdateFileSystemRequest.getter(UpdateFileSystemRequest::windowsConfiguration)).setter(UpdateFileSystemRequest.setter(Builder::windowsConfiguration)).constructor(UpdateFileSystemWindowsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build()}).build();
    private static final SdkField<UpdateFileSystemLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LustreConfiguration").getter(UpdateFileSystemRequest.getter(UpdateFileSystemRequest::lustreConfiguration)).setter(UpdateFileSystemRequest.setter(Builder::lustreConfiguration)).constructor(UpdateFileSystemLustreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, STORAGE_CAPACITY_FIELD, WINDOWS_CONFIGURATION_FIELD, LUSTRE_CONFIGURATION_FIELD));
    private final String fileSystemId;
    private final String clientRequestToken;
    private final Integer storageCapacity;
    private final UpdateFileSystemWindowsConfiguration windowsConfiguration;
    private final UpdateFileSystemLustreConfiguration lustreConfiguration;

    private UpdateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.clientRequestToken = builder.clientRequestToken;
        this.storageCapacity = builder.storageCapacity;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final UpdateFileSystemWindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public final UpdateFileSystemLustreConfiguration lustreConfiguration() {
        return this.lustreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemRequest)) {
            return false;
        }
        UpdateFileSystemRequest other = (UpdateFileSystemRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.windowsConfiguration(), other.windowsConfiguration()) && Objects.equals(this.lustreConfiguration(), other.lustreConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemRequest").add("FileSystemId", (Object)this.fileSystemId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("StorageCapacity", (Object)this.storageCapacity()).add("WindowsConfiguration", (Object)this.windowsConfiguration()).add("LustreConfiguration", (Object)this.lustreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "StorageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "WindowsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.windowsConfiguration()));
            }
            case "LustreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lustreConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemRequest, T> g) {
        return obj -> g.apply((UpdateFileSystemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String clientRequestToken;
        private Integer storageCapacity;
        private UpdateFileSystemWindowsConfiguration windowsConfiguration;
        private UpdateFileSystemLustreConfiguration lustreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemRequest model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.clientRequestToken(model.clientRequestToken);
            this.storageCapacity(model.storageCapacity);
            this.windowsConfiguration(model.windowsConfiguration);
            this.lustreConfiguration(model.lustreConfiguration);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        public final UpdateFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return this.windowsConfiguration != null ? this.windowsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder windowsConfiguration(UpdateFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final void setWindowsConfiguration(UpdateFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        public final UpdateFileSystemLustreConfiguration.Builder getLustreConfiguration() {
            return this.lustreConfiguration != null ? this.lustreConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lustreConfiguration(UpdateFileSystemLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final void setLustreConfiguration(UpdateFileSystemLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileSystemRequest build() {
            return new UpdateFileSystemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemRequest> {
        public Builder fileSystemId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder storageCapacity(Integer var1);

        public Builder windowsConfiguration(UpdateFileSystemWindowsConfiguration var1);

        default public Builder windowsConfiguration(Consumer<UpdateFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return this.windowsConfiguration((UpdateFileSystemWindowsConfiguration)((UpdateFileSystemWindowsConfiguration.Builder)UpdateFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)).build());
        }

        public Builder lustreConfiguration(UpdateFileSystemLustreConfiguration var1);

        default public Builder lustreConfiguration(Consumer<UpdateFileSystemLustreConfiguration.Builder> lustreConfiguration) {
            return this.lustreConfiguration((UpdateFileSystemLustreConfiguration)((UpdateFileSystemLustreConfiguration.Builder)UpdateFileSystemLustreConfiguration.builder().applyMutation(lustreConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

