/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse;

public class ListMemberAccountsPublisher
implements SdkPublisher<ListMemberAccountsResponse> {
    private final FmsAsyncClient client;
    private final ListMemberAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMemberAccountsPublisher(FmsAsyncClient client, ListMemberAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMemberAccountsPublisher(FmsAsyncClient client, ListMemberAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMemberAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMemberAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> memberAccounts() {
        Function<ListMemberAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.memberAccounts() != null) {
                return response.memberAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMemberAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMemberAccountsResponseFetcher
    implements AsyncPageFetcher<ListMemberAccountsResponse> {
        private ListMemberAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemberAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMemberAccountsResponse> nextPage(ListMemberAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListMemberAccountsPublisher.this.client.listMemberAccounts(ListMemberAccountsPublisher.this.firstRequest);
            }
            return ListMemberAccountsPublisher.this.client.listMemberAccounts((ListMemberAccountsRequest)((Object)ListMemberAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

