/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateActionInput;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateActionInputMapCopier;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateStopConditionInput;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateStopConditionInputListCopier;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateTargetInput;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateTargetInputMapCopier;
import software.amazon.awssdk.services.fis.model.FisRequest;
import software.amazon.awssdk.services.fis.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExperimentTemplateRequest
extends FisRequest
implements ToCopyableBuilder<Builder, CreateExperimentTemplateRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateExperimentTemplateRequest.getter(CreateExperimentTemplateRequest::clientToken)).setter(CreateExperimentTemplateRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateExperimentTemplateRequest.getter(CreateExperimentTemplateRequest::description)).setter(CreateExperimentTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<CreateExperimentTemplateStopConditionInput>> STOP_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stopConditions").getter(CreateExperimentTemplateRequest.getter(CreateExperimentTemplateRequest::stopConditions)).setter(CreateExperimentTemplateRequest.setter(Builder::stopConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateExperimentTemplateStopConditionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CreateExperimentTemplateTargetInput>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targets").getter(CreateExperimentTemplateRequest.getter(CreateExperimentTemplateRequest::targets)).setter(CreateExperimentTemplateRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateExperimentTemplateTargetInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CreateExperimentTemplateActionInput>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("actions").getter(CreateExperimentTemplateRequest.getter(CreateExperimentTemplateRequest::actions)).setter(CreateExperimentTemplateRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateExperimentTemplateActionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateExperimentTemplateRequest.getter(CreateExperimentTemplateRequest::roleArn)).setter(CreateExperimentTemplateRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateExperimentTemplateRequest.getter(CreateExperimentTemplateRequest::tags)).setter(CreateExperimentTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, STOP_CONDITIONS_FIELD, TARGETS_FIELD, ACTIONS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final String description;
    private final List<CreateExperimentTemplateStopConditionInput> stopConditions;
    private final Map<String, CreateExperimentTemplateTargetInput> targets;
    private final Map<String, CreateExperimentTemplateActionInput> actions;
    private final String roleArn;
    private final Map<String, String> tags;

    private CreateExperimentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.stopConditions = builder.stopConditions;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasStopConditions() {
        return this.stopConditions != null && !(this.stopConditions instanceof SdkAutoConstructList);
    }

    public final List<CreateExperimentTemplateStopConditionInput> stopConditions() {
        return this.stopConditions;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructMap);
    }

    public final Map<String, CreateExperimentTemplateTargetInput> targets() {
        return this.targets;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructMap);
    }

    public final Map<String, CreateExperimentTemplateActionInput> actions() {
        return this.actions;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopConditions() ? this.stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentTemplateRequest)) {
            return false;
        }
        CreateExperimentTemplateRequest other = (CreateExperimentTemplateRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && this.hasStopConditions() == other.hasStopConditions() && Objects.equals(this.stopConditions(), other.stopConditions()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExperimentTemplateRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("StopConditions", this.hasStopConditions() ? this.stopConditions() : null).add("Targets", this.hasTargets() ? this.targets() : null).add("Actions", this.hasActions() ? this.actions() : null).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "stopConditions": {
                return Optional.ofNullable(clazz.cast(this.stopConditions()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentTemplateRequest, T> g) {
        return obj -> g.apply((CreateExperimentTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private List<CreateExperimentTemplateStopConditionInput> stopConditions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, CreateExperimentTemplateTargetInput> targets = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, CreateExperimentTemplateActionInput> actions = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentTemplateRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.stopConditions(model.stopConditions);
            this.targets(model.targets);
            this.actions(model.actions);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<CreateExperimentTemplateStopConditionInput.Builder> getStopConditions() {
            List<CreateExperimentTemplateStopConditionInput.Builder> result = CreateExperimentTemplateStopConditionInputListCopier.copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stopConditions(Collection<CreateExperimentTemplateStopConditionInput> stopConditions) {
            this.stopConditions = CreateExperimentTemplateStopConditionInputListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(CreateExperimentTemplateStopConditionInput ... stopConditions) {
            this.stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<CreateExperimentTemplateStopConditionInput.Builder> ... stopConditions) {
            this.stopConditions(Stream.of(stopConditions).map(c -> (CreateExperimentTemplateStopConditionInput)((CreateExperimentTemplateStopConditionInput.Builder)CreateExperimentTemplateStopConditionInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStopConditions(Collection<CreateExperimentTemplateStopConditionInput.BuilderImpl> stopConditions) {
            this.stopConditions = CreateExperimentTemplateStopConditionInputListCopier.copyFromBuilder(stopConditions);
        }

        public final Map<String, CreateExperimentTemplateTargetInput.Builder> getTargets() {
            Map<String, CreateExperimentTemplateTargetInput.Builder> result = CreateExperimentTemplateTargetInputMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targets(Map<String, CreateExperimentTemplateTargetInput> targets) {
            this.targets = CreateExperimentTemplateTargetInputMapCopier.copy(targets);
            return this;
        }

        public final void setTargets(Map<String, CreateExperimentTemplateTargetInput.BuilderImpl> targets) {
            this.targets = CreateExperimentTemplateTargetInputMapCopier.copyFromBuilder(targets);
        }

        public final Map<String, CreateExperimentTemplateActionInput.Builder> getActions() {
            Map<String, CreateExperimentTemplateActionInput.Builder> result = CreateExperimentTemplateActionInputMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actions(Map<String, CreateExperimentTemplateActionInput> actions) {
            this.actions = CreateExperimentTemplateActionInputMapCopier.copy(actions);
            return this;
        }

        public final void setActions(Map<String, CreateExperimentTemplateActionInput.BuilderImpl> actions) {
            this.actions = CreateExperimentTemplateActionInputMapCopier.copyFromBuilder(actions);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExperimentTemplateRequest build() {
            return new CreateExperimentTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExperimentTemplateRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder stopConditions(Collection<CreateExperimentTemplateStopConditionInput> var1);

        public Builder stopConditions(CreateExperimentTemplateStopConditionInput ... var1);

        public Builder stopConditions(Consumer<CreateExperimentTemplateStopConditionInput.Builder> ... var1);

        public Builder targets(Map<String, CreateExperimentTemplateTargetInput> var1);

        public Builder actions(Map<String, CreateExperimentTemplateActionInput> var1);

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

