/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.Listener;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerListenersDescriptionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerDescription> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(LoadBalancerDescription.getter(LoadBalancerDescription::loadBalancerName)).setter(LoadBalancerDescription.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(LoadBalancerDescription.getter(LoadBalancerDescription::domain)).setter(LoadBalancerDescription.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Listeners").getter(LoadBalancerDescription.getter(LoadBalancerDescription::listeners)).setter(LoadBalancerDescription.setter(Builder::listeners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listeners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Listener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, DOMAIN_FIELD, LISTENERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String loadBalancerName;
    private final String domain;
    private final List<Listener> listeners;

    private LoadBalancerDescription(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.domain = builder.domain;
        this.listeners = builder.listeners;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final String domain() {
        return this.domain;
    }

    public final boolean hasListeners() {
        return this.listeners != null && !(this.listeners instanceof SdkAutoConstructList);
    }

    public final List<Listener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListeners() ? this.listeners() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription)obj;
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.domain(), other.domain()) && this.hasListeners() == other.hasListeners() && Objects.equals(this.listeners(), other.listeners());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancerDescription").add("LoadBalancerName", (Object)this.loadBalancerName()).add("Domain", (Object)this.domain()).add("Listeners", this.hasListeners() ? this.listeners() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Listeners": {
                return Optional.ofNullable(clazz.cast(this.listeners()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerDescription, T> g) {
        return obj -> g.apply((LoadBalancerDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String domain;
        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerDescription model) {
            this.loadBalancerName(model.loadBalancerName);
            this.domain(model.domain);
            this.listeners(model.listeners);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final List<Listener.Builder> getListeners() {
            List<Listener.Builder> result = LoadBalancerListenersDescriptionCopier.copyToBuilder(this.listeners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = LoadBalancerListenersDescriptionCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder> ... listeners) {
            this.listeners(Stream.of(listeners).map(c -> (Listener)((Listener.Builder)Listener.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = LoadBalancerListenersDescriptionCopier.copyFromBuilder(listeners);
        }

        public LoadBalancerDescription build() {
            return new LoadBalancerDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerDescription> {
        public Builder loadBalancerName(String var1);

        public Builder domain(String var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);

        public Builder listeners(Consumer<Listener.Builder> ... var1);
    }
}

