/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DestinationType {
    CLOUDWATCH_LOGS("cloudwatch-logs"),
    KINESIS_FIREHOSE("kinesis-firehose"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DestinationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DestinationType> knownValues() {
        return Stream.of(DestinationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

