/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.model.DescribeAddonRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonResponse;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse;
import software.amazon.awssdk.services.eks.waiters.DefaultEksAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
public interface EksAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonActive(DescribeAddonRequest describeAddonRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonActive(Consumer<DescribeAddonRequest.Builder> describeAddonRequest) {
        return this.waitUntilAddonActive((DescribeAddonRequest)((Object)((DescribeAddonRequest.Builder)DescribeAddonRequest.builder().applyMutation(describeAddonRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonActive(DescribeAddonRequest describeAddonRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonActive(Consumer<DescribeAddonRequest.Builder> describeAddonRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilAddonActive((DescribeAddonRequest)((Object)((DescribeAddonRequest.Builder)DescribeAddonRequest.builder().applyMutation(describeAddonRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonDeleted(DescribeAddonRequest describeAddonRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonDeleted(Consumer<DescribeAddonRequest.Builder> describeAddonRequest) {
        return this.waitUntilAddonDeleted((DescribeAddonRequest)((Object)((DescribeAddonRequest.Builder)DescribeAddonRequest.builder().applyMutation(describeAddonRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonDeleted(DescribeAddonRequest describeAddonRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAddonResponse>> waitUntilAddonDeleted(Consumer<DescribeAddonRequest.Builder> describeAddonRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilAddonDeleted((DescribeAddonRequest)((Object)((DescribeAddonRequest.Builder)DescribeAddonRequest.builder().applyMutation(describeAddonRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterActive(DescribeClusterRequest describeClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterActive(Consumer<DescribeClusterRequest.Builder> describeClusterRequest) {
        return this.waitUntilClusterActive((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterActive(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterActive(Consumer<DescribeClusterRequest.Builder> describeClusterRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilClusterActive((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(Consumer<DescribeClusterRequest.Builder> describeClusterRequest) {
        return this.waitUntilClusterDeleted((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(Consumer<DescribeClusterRequest.Builder> describeClusterRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilClusterDeleted((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupActive(DescribeNodegroupRequest describeNodegroupRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupActive(Consumer<DescribeNodegroupRequest.Builder> describeNodegroupRequest) {
        return this.waitUntilNodegroupActive((DescribeNodegroupRequest)((Object)((DescribeNodegroupRequest.Builder)DescribeNodegroupRequest.builder().applyMutation(describeNodegroupRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupActive(DescribeNodegroupRequest describeNodegroupRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupActive(Consumer<DescribeNodegroupRequest.Builder> describeNodegroupRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilNodegroupActive((DescribeNodegroupRequest)((Object)((DescribeNodegroupRequest.Builder)DescribeNodegroupRequest.builder().applyMutation(describeNodegroupRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupDeleted(DescribeNodegroupRequest describeNodegroupRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupDeleted(Consumer<DescribeNodegroupRequest.Builder> describeNodegroupRequest) {
        return this.waitUntilNodegroupDeleted((DescribeNodegroupRequest)((Object)((DescribeNodegroupRequest.Builder)DescribeNodegroupRequest.builder().applyMutation(describeNodegroupRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupDeleted(DescribeNodegroupRequest describeNodegroupRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupDeleted(Consumer<DescribeNodegroupRequest.Builder> describeNodegroupRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilNodegroupDeleted((DescribeNodegroupRequest)((Object)((DescribeNodegroupRequest.Builder)DescribeNodegroupRequest.builder().applyMutation(describeNodegroupRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultEksAsyncWaiter.builder();
    }

    public static EksAsyncWaiter create() {
        return DefaultEksAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(EksAsyncClient var1);

        public EksAsyncWaiter build();
    }
}

