/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.NodegroupScalingConfig;
import software.amazon.awssdk.services.eks.model.UpdateLabelsPayload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNodegroupConfigRequest
extends EksRequest
implements ToCopyableBuilder<Builder, UpdateNodegroupConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(UpdateNodegroupConfigRequest.getter(UpdateNodegroupConfigRequest::clusterName)).setter(UpdateNodegroupConfigRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodegroupName").getter(UpdateNodegroupConfigRequest.getter(UpdateNodegroupConfigRequest::nodegroupName)).setter(UpdateNodegroupConfigRequest.setter(Builder::nodegroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodegroupName").build()}).build();
    private static final SdkField<UpdateLabelsPayload> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("labels").getter(UpdateNodegroupConfigRequest.getter(UpdateNodegroupConfigRequest::labels)).setter(UpdateNodegroupConfigRequest.setter(Builder::labels)).constructor(UpdateLabelsPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build()}).build();
    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingConfig").getter(UpdateNodegroupConfigRequest.getter(UpdateNodegroupConfigRequest::scalingConfig)).setter(UpdateNodegroupConfigRequest.setter(Builder::scalingConfig)).constructor(NodegroupScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateNodegroupConfigRequest.getter(UpdateNodegroupConfigRequest::clientRequestToken)).setter(UpdateNodegroupConfigRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODEGROUP_NAME_FIELD, LABELS_FIELD, SCALING_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String clusterName;
    private final String nodegroupName;
    private final UpdateLabelsPayload labels;
    private final NodegroupScalingConfig scalingConfig;
    private final String clientRequestToken;

    private UpdateNodegroupConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.labels = builder.labels;
        this.scalingConfig = builder.scalingConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String nodegroupName() {
        return this.nodegroupName;
    }

    public final UpdateLabelsPayload labels() {
        return this.labels;
    }

    public final NodegroupScalingConfig scalingConfig() {
        return this.scalingConfig;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupConfigRequest)) {
            return false;
        }
        UpdateNodegroupConfigRequest other = (UpdateNodegroupConfigRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodegroupName(), other.nodegroupName()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.scalingConfig(), other.scalingConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNodegroupConfigRequest").add("ClusterName", (Object)this.clusterName()).add("NodegroupName", (Object)this.nodegroupName()).add("Labels", (Object)this.labels()).add("ScalingConfig", (Object)this.scalingConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "nodegroupName": {
                return Optional.ofNullable(clazz.cast(this.nodegroupName()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "scalingConfig": {
                return Optional.ofNullable(clazz.cast(this.scalingConfig()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupConfigRequest, T> g) {
        return obj -> g.apply((UpdateNodegroupConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodegroupName;
        private UpdateLabelsPayload labels;
        private NodegroupScalingConfig scalingConfig;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupConfigRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodegroupName(model.nodegroupName);
            this.labels(model.labels);
            this.scalingConfig(model.scalingConfig);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodegroupName() {
            return this.nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final UpdateLabelsPayload.Builder getLabels() {
            return this.labels != null ? this.labels.toBuilder() : null;
        }

        @Override
        public final Builder labels(UpdateLabelsPayload labels) {
            this.labels = labels;
            return this;
        }

        public final void setLabels(UpdateLabelsPayload.BuilderImpl labels) {
            this.labels = labels != null ? labels.build() : null;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return this.scalingConfig != null ? this.scalingConfig.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodegroupConfigRequest build() {
            return new UpdateNodegroupConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNodegroupConfigRequest> {
        public Builder clusterName(String var1);

        public Builder nodegroupName(String var1);

        public Builder labels(UpdateLabelsPayload var1);

        default public Builder labels(Consumer<UpdateLabelsPayload.Builder> labels) {
            return this.labels((UpdateLabelsPayload)((UpdateLabelsPayload.Builder)UpdateLabelsPayload.builder().applyMutation(labels)).build());
        }

        public Builder scalingConfig(NodegroupScalingConfig var1);

        default public Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return this.scalingConfig((NodegroupScalingConfig)((NodegroupScalingConfig.Builder)NodegroupScalingConfig.builder().applyMutation(scalingConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

