/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable;

public class DescribeTransitGatewayRouteTablesPublisher
implements SdkPublisher<DescribeTransitGatewayRouteTablesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTransitGatewayRouteTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTransitGatewayRouteTablesPublisher(Ec2AsyncClient client, DescribeTransitGatewayRouteTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTransitGatewayRouteTablesPublisher(Ec2AsyncClient client, DescribeTransitGatewayRouteTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTransitGatewayRouteTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTransitGatewayRouteTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayRouteTable> transitGatewayRouteTables() {
        Function<DescribeTransitGatewayRouteTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayRouteTables() != null) {
                return response.transitGatewayRouteTables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTransitGatewayRouteTablesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTransitGatewayRouteTablesResponseFetcher
    implements AsyncPageFetcher<DescribeTransitGatewayRouteTablesResponse> {
        private DescribeTransitGatewayRouteTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayRouteTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTransitGatewayRouteTablesResponse> nextPage(DescribeTransitGatewayRouteTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayRouteTablesPublisher.this.client.describeTransitGatewayRouteTables(DescribeTransitGatewayRouteTablesPublisher.this.firstRequest);
            }
            return DescribeTransitGatewayRouteTablesPublisher.this.client.describeTransitGatewayRouteTables((DescribeTransitGatewayRouteTablesRequest)((Object)DescribeTransitGatewayRouteTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

