/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.ExportImageTask;

public class DescribeExportImageTasksIterable
implements SdkIterable<DescribeExportImageTasksResponse> {
    private final Ec2Client client;
    private final DescribeExportImageTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeExportImageTasksIterable(Ec2Client client, DescribeExportImageTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeExportImageTasksResponseFetcher();
    }

    public Iterator<DescribeExportImageTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportImageTask> exportImageTasks() {
        Function<DescribeExportImageTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.exportImageTasks() != null) {
                return response.exportImageTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeExportImageTasksResponseFetcher
    implements SyncPageFetcher<DescribeExportImageTasksResponse> {
        private DescribeExportImageTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeExportImageTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeExportImageTasksResponse nextPage(DescribeExportImageTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeExportImageTasksIterable.this.client.describeExportImageTasks(DescribeExportImageTasksIterable.this.firstRequest);
            }
            return DescribeExportImageTasksIterable.this.client.describeExportImageTasks((DescribeExportImageTasksRequest)((Object)DescribeExportImageTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

