/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue;
import software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue;
import software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMulticastDomainOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMulticastDomainOptions> {
    private static final SdkField<String> IGMPV2_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Igmpv2Support").getter(TransitGatewayMulticastDomainOptions.getter(TransitGatewayMulticastDomainOptions::igmpv2SupportAsString)).setter(TransitGatewayMulticastDomainOptions.setter(Builder::igmpv2Support)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Igmpv2Support").unmarshallLocationName("igmpv2Support").build()}).build();
    private static final SdkField<String> STATIC_SOURCES_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StaticSourcesSupport").getter(TransitGatewayMulticastDomainOptions.getter(TransitGatewayMulticastDomainOptions::staticSourcesSupportAsString)).setter(TransitGatewayMulticastDomainOptions.setter(Builder::staticSourcesSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticSourcesSupport").unmarshallLocationName("staticSourcesSupport").build()}).build();
    private static final SdkField<String> AUTO_ACCEPT_SHARED_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoAcceptSharedAssociations").getter(TransitGatewayMulticastDomainOptions.getter(TransitGatewayMulticastDomainOptions::autoAcceptSharedAssociationsAsString)).setter(TransitGatewayMulticastDomainOptions.setter(Builder::autoAcceptSharedAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAssociations").unmarshallLocationName("autoAcceptSharedAssociations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IGMPV2_SUPPORT_FIELD, STATIC_SOURCES_SUPPORT_FIELD, AUTO_ACCEPT_SHARED_ASSOCIATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String igmpv2Support;
    private final String staticSourcesSupport;
    private final String autoAcceptSharedAssociations;

    private TransitGatewayMulticastDomainOptions(BuilderImpl builder) {
        this.igmpv2Support = builder.igmpv2Support;
        this.staticSourcesSupport = builder.staticSourcesSupport;
        this.autoAcceptSharedAssociations = builder.autoAcceptSharedAssociations;
    }

    public final Igmpv2SupportValue igmpv2Support() {
        return Igmpv2SupportValue.fromValue(this.igmpv2Support);
    }

    public final String igmpv2SupportAsString() {
        return this.igmpv2Support;
    }

    public final StaticSourcesSupportValue staticSourcesSupport() {
        return StaticSourcesSupportValue.fromValue(this.staticSourcesSupport);
    }

    public final String staticSourcesSupportAsString() {
        return this.staticSourcesSupport;
    }

    public final AutoAcceptSharedAssociationsValue autoAcceptSharedAssociations() {
        return AutoAcceptSharedAssociationsValue.fromValue(this.autoAcceptSharedAssociations);
    }

    public final String autoAcceptSharedAssociationsAsString() {
        return this.autoAcceptSharedAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.igmpv2SupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticSourcesSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAcceptSharedAssociationsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastDomainOptions)) {
            return false;
        }
        TransitGatewayMulticastDomainOptions other = (TransitGatewayMulticastDomainOptions)obj;
        return Objects.equals(this.igmpv2SupportAsString(), other.igmpv2SupportAsString()) && Objects.equals(this.staticSourcesSupportAsString(), other.staticSourcesSupportAsString()) && Objects.equals(this.autoAcceptSharedAssociationsAsString(), other.autoAcceptSharedAssociationsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayMulticastDomainOptions").add("Igmpv2Support", (Object)this.igmpv2SupportAsString()).add("StaticSourcesSupport", (Object)this.staticSourcesSupportAsString()).add("AutoAcceptSharedAssociations", (Object)this.autoAcceptSharedAssociationsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Igmpv2Support": {
                return Optional.ofNullable(clazz.cast(this.igmpv2SupportAsString()));
            }
            case "StaticSourcesSupport": {
                return Optional.ofNullable(clazz.cast(this.staticSourcesSupportAsString()));
            }
            case "AutoAcceptSharedAssociations": {
                return Optional.ofNullable(clazz.cast(this.autoAcceptSharedAssociationsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastDomainOptions, T> g) {
        return obj -> g.apply((TransitGatewayMulticastDomainOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String igmpv2Support;
        private String staticSourcesSupport;
        private String autoAcceptSharedAssociations;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastDomainOptions model) {
            this.igmpv2Support(model.igmpv2Support);
            this.staticSourcesSupport(model.staticSourcesSupport);
            this.autoAcceptSharedAssociations(model.autoAcceptSharedAssociations);
        }

        public final String getIgmpv2Support() {
            return this.igmpv2Support;
        }

        @Override
        public final Builder igmpv2Support(String igmpv2Support) {
            this.igmpv2Support = igmpv2Support;
            return this;
        }

        @Override
        public final Builder igmpv2Support(Igmpv2SupportValue igmpv2Support) {
            this.igmpv2Support(igmpv2Support == null ? null : igmpv2Support.toString());
            return this;
        }

        public final void setIgmpv2Support(String igmpv2Support) {
            this.igmpv2Support = igmpv2Support;
        }

        public final String getStaticSourcesSupport() {
            return this.staticSourcesSupport;
        }

        @Override
        public final Builder staticSourcesSupport(String staticSourcesSupport) {
            this.staticSourcesSupport = staticSourcesSupport;
            return this;
        }

        @Override
        public final Builder staticSourcesSupport(StaticSourcesSupportValue staticSourcesSupport) {
            this.staticSourcesSupport(staticSourcesSupport == null ? null : staticSourcesSupport.toString());
            return this;
        }

        public final void setStaticSourcesSupport(String staticSourcesSupport) {
            this.staticSourcesSupport = staticSourcesSupport;
        }

        public final String getAutoAcceptSharedAssociations() {
            return this.autoAcceptSharedAssociations;
        }

        @Override
        public final Builder autoAcceptSharedAssociations(String autoAcceptSharedAssociations) {
            this.autoAcceptSharedAssociations = autoAcceptSharedAssociations;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAssociations(AutoAcceptSharedAssociationsValue autoAcceptSharedAssociations) {
            this.autoAcceptSharedAssociations(autoAcceptSharedAssociations == null ? null : autoAcceptSharedAssociations.toString());
            return this;
        }

        public final void setAutoAcceptSharedAssociations(String autoAcceptSharedAssociations) {
            this.autoAcceptSharedAssociations = autoAcceptSharedAssociations;
        }

        public TransitGatewayMulticastDomainOptions build() {
            return new TransitGatewayMulticastDomainOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMulticastDomainOptions> {
        public Builder igmpv2Support(String var1);

        public Builder igmpv2Support(Igmpv2SupportValue var1);

        public Builder staticSourcesSupport(String var1);

        public Builder staticSourcesSupport(StaticSourcesSupportValue var1);

        public Builder autoAcceptSharedAssociations(String var1);

        public Builder autoAcceptSharedAssociations(AutoAcceptSharedAssociationsValue var1);
    }
}

