/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyPairInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyPairInfo> {
    private static final SdkField<String> KEY_PAIR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPairId").getter(KeyPairInfo.getter(KeyPairInfo::keyPairId)).setter(KeyPairInfo.setter(Builder::keyPairId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("keyPairId").build()}).build();
    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFingerprint").getter(KeyPairInfo.getter(KeyPairInfo::keyFingerprint)).setter(KeyPairInfo.setter(Builder::keyFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint").unmarshallLocationName("keyFingerprint").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(KeyPairInfo.getter(KeyPairInfo::keyName)).setter(KeyPairInfo.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(KeyPairInfo.getter(KeyPairInfo::tags)).setter(KeyPairInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIR_ID_FIELD, KEY_FINGERPRINT_FIELD, KEY_NAME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyPairId;
    private final String keyFingerprint;
    private final String keyName;
    private final List<Tag> tags;

    private KeyPairInfo(BuilderImpl builder) {
        this.keyPairId = builder.keyPairId;
        this.keyFingerprint = builder.keyFingerprint;
        this.keyName = builder.keyName;
        this.tags = builder.tags;
    }

    public final String keyPairId() {
        return this.keyPairId;
    }

    public final String keyFingerprint() {
        return this.keyFingerprint;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPairInfo)) {
            return false;
        }
        KeyPairInfo other = (KeyPairInfo)obj;
        return Objects.equals(this.keyPairId(), other.keyPairId()) && Objects.equals(this.keyFingerprint(), other.keyFingerprint()) && Objects.equals(this.keyName(), other.keyName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"KeyPairInfo").add("KeyPairId", (Object)this.keyPairId()).add("KeyFingerprint", (Object)this.keyFingerprint()).add("KeyName", (Object)this.keyName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPairId": {
                return Optional.ofNullable(clazz.cast(this.keyPairId()));
            }
            case "KeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.keyFingerprint()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyPairInfo, T> g) {
        return obj -> g.apply((KeyPairInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyPairId;
        private String keyFingerprint;
        private String keyName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPairInfo model) {
            this.keyPairId(model.keyPairId);
            this.keyFingerprint(model.keyFingerprint);
            this.keyName(model.keyName);
            this.tags(model.tags);
        }

        public final String getKeyPairId() {
            return this.keyPairId;
        }

        @Override
        public final Builder keyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
            return this;
        }

        public final void setKeyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
        }

        public final String getKeyFingerprint() {
            return this.keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public KeyPairInfo build() {
            return new KeyPairInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyPairInfo> {
        public Builder keyPairId(String var1);

        public Builder keyFingerprint(String var1);

        public Builder keyName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

