/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventCode {
    INSTANCE_REBOOT("instance-reboot"),
    SYSTEM_REBOOT("system-reboot"),
    SYSTEM_MAINTENANCE("system-maintenance"),
    INSTANCE_RETIREMENT("instance-retirement"),
    INSTANCE_STOP("instance-stop"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventCode> knownValues() {
        return Stream.of(EventCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

