/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsServersOptionsModifyStructure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsServersOptionsModifyStructure> {
    private static final SdkField<List<String>> CUSTOM_DNS_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomDnsServers").getter(DnsServersOptionsModifyStructure.getter(DnsServersOptionsModifyStructure::customDnsServers)).setter(DnsServersOptionsModifyStructure.setter(Builder::customDnsServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDnsServers").unmarshallLocationName("CustomDnsServers").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DnsServersOptionsModifyStructure.getter(DnsServersOptionsModifyStructure::enabled)).setter(DnsServersOptionsModifyStructure.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DNS_SERVERS_FIELD, ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> customDnsServers;
    private final Boolean enabled;

    private DnsServersOptionsModifyStructure(BuilderImpl builder) {
        this.customDnsServers = builder.customDnsServers;
        this.enabled = builder.enabled;
    }

    public final boolean hasCustomDnsServers() {
        return this.customDnsServers != null && !(this.customDnsServers instanceof SdkAutoConstructList);
    }

    public final List<String> customDnsServers() {
        return this.customDnsServers;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDnsServers() ? this.customDnsServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsServersOptionsModifyStructure)) {
            return false;
        }
        DnsServersOptionsModifyStructure other = (DnsServersOptionsModifyStructure)obj;
        return this.hasCustomDnsServers() == other.hasCustomDnsServers() && Objects.equals(this.customDnsServers(), other.customDnsServers()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"DnsServersOptionsModifyStructure").add("CustomDnsServers", this.hasCustomDnsServers() ? this.customDnsServers() : null).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomDnsServers": {
                return Optional.ofNullable(clazz.cast(this.customDnsServers()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsServersOptionsModifyStructure, T> g) {
        return obj -> g.apply((DnsServersOptionsModifyStructure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> customDnsServers = DefaultSdkAutoConstructList.getInstance();
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsServersOptionsModifyStructure model) {
            this.customDnsServers(model.customDnsServers);
            this.enabled(model.enabled);
        }

        public final Collection<String> getCustomDnsServers() {
            if (this.customDnsServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customDnsServers;
        }

        @Override
        public final Builder customDnsServers(Collection<String> customDnsServers) {
            this.customDnsServers = ValueStringListCopier.copy(customDnsServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDnsServers(String ... customDnsServers) {
            this.customDnsServers(Arrays.asList(customDnsServers));
            return this;
        }

        public final void setCustomDnsServers(Collection<String> customDnsServers) {
            this.customDnsServers = ValueStringListCopier.copy(customDnsServers);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public DnsServersOptionsModifyStructure build() {
            return new DnsServersOptionsModifyStructure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsServersOptionsModifyStructure> {
        public Builder customDnsServers(Collection<String> var1);

        public Builder customDnsServers(String ... var1);

        public Builder enabled(Boolean var1);
    }
}

