/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(CreateRouteRequest.getter(CreateRouteRequest::destinationCidrBlock)).setter(CreateRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIpv6CidrBlock").getter(CreateRouteRequest.getter(CreateRouteRequest::destinationIpv6CidrBlock)).setter(CreateRouteRequest.setter(Builder::destinationIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").unmarshallLocationName("destinationIpv6CidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPrefixListId").getter(CreateRouteRequest.getter(CreateRouteRequest::destinationPrefixListId)).setter(CreateRouteRequest.setter(Builder::destinationPrefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").unmarshallLocationName("DestinationPrefixListId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(CreateRouteRequest.getter(CreateRouteRequest::vpcEndpointId)).setter(CreateRouteRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EgressOnlyInternetGatewayId").getter(CreateRouteRequest.getter(CreateRouteRequest::egressOnlyInternetGatewayId)).setter(CreateRouteRequest.setter(Builder::egressOnlyInternetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId").unmarshallLocationName("egressOnlyInternetGatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayId").getter(CreateRouteRequest.getter(CreateRouteRequest::gatewayId)).setter(CreateRouteRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").unmarshallLocationName("gatewayId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateRouteRequest.getter(CreateRouteRequest::instanceId)).setter(CreateRouteRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(CreateRouteRequest.getter(CreateRouteRequest::natGatewayId)).setter(CreateRouteRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("natGatewayId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(CreateRouteRequest.getter(CreateRouteRequest::transitGatewayId)).setter(CreateRouteRequest.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("TransitGatewayId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayId").getter(CreateRouteRequest.getter(CreateRouteRequest::localGatewayId)).setter(CreateRouteRequest.setter(Builder::localGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").unmarshallLocationName("LocalGatewayId").build()}).build();
    private static final SdkField<String> CARRIER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CarrierGatewayId").getter(CreateRouteRequest.getter(CreateRouteRequest::carrierGatewayId)).setter(CreateRouteRequest.setter(Builder::carrierGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewayId").unmarshallLocationName("CarrierGatewayId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateRouteRequest.getter(CreateRouteRequest::networkInterfaceId)).setter(CreateRouteRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(CreateRouteRequest.getter(CreateRouteRequest::routeTableId)).setter(CreateRouteRequest.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("routeTableId").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcPeeringConnectionId").getter(CreateRouteRequest.getter(CreateRouteRequest::vpcPeeringConnectionId)).setter(CreateRouteRequest.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("vpcPeeringConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD, VPC_ENDPOINT_ID_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, INSTANCE_ID_FIELD, NAT_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, CARRIER_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, ROUTE_TABLE_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));
    private final String destinationCidrBlock;
    private final String destinationIpv6CidrBlock;
    private final String destinationPrefixListId;
    private final String vpcEndpointId;
    private final String egressOnlyInternetGatewayId;
    private final String gatewayId;
    private final String instanceId;
    private final String natGatewayId;
    private final String transitGatewayId;
    private final String localGatewayId;
    private final String carrierGatewayId;
    private final String networkInterfaceId;
    private final String routeTableId;
    private final String vpcPeeringConnectionId;

    private CreateRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.natGatewayId = builder.natGatewayId;
        this.transitGatewayId = builder.transitGatewayId;
        this.localGatewayId = builder.localGatewayId;
        this.carrierGatewayId = builder.carrierGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.routeTableId = builder.routeTableId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public final String destinationPrefixListId() {
        return this.destinationPrefixListId;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final String localGatewayId() {
        return this.localGatewayId;
    }

    public final String carrierGatewayId() {
        return this.carrierGatewayId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrierGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteRequest)) {
            return false;
        }
        CreateRouteRequest other = (CreateRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock()) && Objects.equals(this.destinationPrefixListId(), other.destinationPrefixListId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.localGatewayId(), other.localGatewayId()) && Objects.equals(this.carrierGatewayId(), other.carrierGatewayId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).add("DestinationPrefixListId", (Object)this.destinationPrefixListId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("EgressOnlyInternetGatewayId", (Object)this.egressOnlyInternetGatewayId()).add("GatewayId", (Object)this.gatewayId()).add("InstanceId", (Object)this.instanceId()).add("NatGatewayId", (Object)this.natGatewayId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("LocalGatewayId", (Object)this.localGatewayId()).add("CarrierGatewayId", (Object)this.carrierGatewayId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("RouteTableId", (Object)this.routeTableId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "DestinationPrefixListId": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixListId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "EgressOnlyInternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGatewayId()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "LocalGatewayId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayId()));
            }
            case "CarrierGatewayId": {
                return Optional.ofNullable(clazz.cast(this.carrierGatewayId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteRequest, T> g) {
        return obj -> g.apply((CreateRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String destinationIpv6CidrBlock;
        private String destinationPrefixListId;
        private String vpcEndpointId;
        private String egressOnlyInternetGatewayId;
        private String gatewayId;
        private String instanceId;
        private String natGatewayId;
        private String transitGatewayId;
        private String localGatewayId;
        private String carrierGatewayId;
        private String networkInterfaceId;
        private String routeTableId;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.destinationPrefixListId(model.destinationPrefixListId);
            this.vpcEndpointId(model.vpcEndpointId);
            this.egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            this.gatewayId(model.gatewayId);
            this.instanceId(model.instanceId);
            this.natGatewayId(model.natGatewayId);
            this.transitGatewayId(model.transitGatewayId);
            this.localGatewayId(model.localGatewayId);
            this.carrierGatewayId(model.carrierGatewayId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.routeTableId(model.routeTableId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getLocalGatewayId() {
            return this.localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final String getCarrierGatewayId() {
            return this.carrierGatewayId;
        }

        @Override
        public final Builder carrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        public final void setCarrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteRequest build() {
            return new CreateRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder destinationPrefixListId(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder egressOnlyInternetGatewayId(String var1);

        public Builder gatewayId(String var1);

        public Builder instanceId(String var1);

        public Builder natGatewayId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder localGatewayId(String var1);

        public Builder carrierGatewayId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder routeTableId(String var1);

        public Builder vpcPeeringConnectionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

