/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class DynamoDbAsyncEndpointDiscoveryCacheLoader
implements EndpointDiscoveryCacheLoader {
    private final DynamoDbAsyncClient client;

    DynamoDbAsyncEndpointDiscoveryCacheLoader(DynamoDbAsyncClient client) {
        this.client = client;
    }

    public static DynamoDbAsyncEndpointDiscoveryCacheLoader create(DynamoDbAsyncClient client) {
        return new DynamoDbAsyncEndpointDiscoveryCacheLoader(client);
    }

    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest endpointDiscoveryRequest) {
        return this.client.describeEndpoints((DescribeEndpointsRequest)((Object)DescribeEndpointsRequest.builder().build())).thenApply(r -> {
            List<Endpoint> endpoints = r.endpoints();
            Validate.notEmpty(endpoints, (String)"Endpoints returned by service for endpoint discovery must not be empty.", (Object[])new Object[0]);
            Endpoint endpoint = endpoints.get(0);
            return EndpointDiscoveryEndpoint.builder().endpoint(this.toUri(endpoint.address(), endpointDiscoveryRequest.defaultEndpoint())).expirationTime(Instant.now().plus((long)endpoint.cachePeriodInMinutes(), ChronoUnit.MINUTES)).build();
        });
    }
}

