/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.model.Event;
import software.amazon.awssdk.services.devopsguru.model.ListEventsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListEventsResponse;

public class ListEventsIterable
implements SdkIterable<ListEventsResponse> {
    private final DevOpsGuruClient client;
    private final ListEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventsIterable(DevOpsGuruClient client, ListEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEventsResponseFetcher();
    }

    public Iterator<ListEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Event> events() {
        Function<ListEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventsResponseFetcher
    implements SyncPageFetcher<ListEventsResponse> {
        private ListEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventsResponse nextPage(ListEventsResponse previousPage) {
            if (previousPage == null) {
                return ListEventsIterable.this.client.listEvents(ListEventsIterable.this.firstRequest);
            }
            return ListEventsIterable.this.client.listEvents((ListEventsRequest)((Object)ListEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

