/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InsightStatus {
    ONGOING("ONGOING"),
    CLOSED("CLOSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InsightStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InsightStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InsightStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InsightStatus> knownValues() {
        return Stream.of(InsightStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

