/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveAnomaly;
import software.amazon.awssdk.services.devopsguru.model.ReactiveAnomaly;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnomalyResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, DescribeAnomalyResponse> {
    private static final SdkField<ProactiveAnomaly> PROACTIVE_ANOMALY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProactiveAnomaly").getter(DescribeAnomalyResponse.getter(DescribeAnomalyResponse::proactiveAnomaly)).setter(DescribeAnomalyResponse.setter(Builder::proactiveAnomaly)).constructor(ProactiveAnomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveAnomaly").build()}).build();
    private static final SdkField<ReactiveAnomaly> REACTIVE_ANOMALY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReactiveAnomaly").getter(DescribeAnomalyResponse.getter(DescribeAnomalyResponse::reactiveAnomaly)).setter(DescribeAnomalyResponse.setter(Builder::reactiveAnomaly)).constructor(ReactiveAnomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveAnomaly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_ANOMALY_FIELD, REACTIVE_ANOMALY_FIELD));
    private final ProactiveAnomaly proactiveAnomaly;
    private final ReactiveAnomaly reactiveAnomaly;

    private DescribeAnomalyResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveAnomaly = builder.proactiveAnomaly;
        this.reactiveAnomaly = builder.reactiveAnomaly;
    }

    public final ProactiveAnomaly proactiveAnomaly() {
        return this.proactiveAnomaly;
    }

    public final ReactiveAnomaly reactiveAnomaly() {
        return this.reactiveAnomaly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proactiveAnomaly());
        hashCode = 31 * hashCode + Objects.hashCode(this.reactiveAnomaly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyResponse)) {
            return false;
        }
        DescribeAnomalyResponse other = (DescribeAnomalyResponse)((Object)obj);
        return Objects.equals(this.proactiveAnomaly(), other.proactiveAnomaly()) && Objects.equals(this.reactiveAnomaly(), other.reactiveAnomaly());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAnomalyResponse").add("ProactiveAnomaly", (Object)this.proactiveAnomaly()).add("ReactiveAnomaly", (Object)this.reactiveAnomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProactiveAnomaly": {
                return Optional.ofNullable(clazz.cast(this.proactiveAnomaly()));
            }
            case "ReactiveAnomaly": {
                return Optional.ofNullable(clazz.cast(this.reactiveAnomaly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private ProactiveAnomaly proactiveAnomaly;
        private ReactiveAnomaly reactiveAnomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyResponse model) {
            super(model);
            this.proactiveAnomaly(model.proactiveAnomaly);
            this.reactiveAnomaly(model.reactiveAnomaly);
        }

        public final ProactiveAnomaly.Builder getProactiveAnomaly() {
            return this.proactiveAnomaly != null ? this.proactiveAnomaly.toBuilder() : null;
        }

        @Override
        public final Builder proactiveAnomaly(ProactiveAnomaly proactiveAnomaly) {
            this.proactiveAnomaly = proactiveAnomaly;
            return this;
        }

        public final void setProactiveAnomaly(ProactiveAnomaly.BuilderImpl proactiveAnomaly) {
            this.proactiveAnomaly = proactiveAnomaly != null ? proactiveAnomaly.build() : null;
        }

        public final ReactiveAnomaly.Builder getReactiveAnomaly() {
            return this.reactiveAnomaly != null ? this.reactiveAnomaly.toBuilder() : null;
        }

        @Override
        public final Builder reactiveAnomaly(ReactiveAnomaly reactiveAnomaly) {
            this.reactiveAnomaly = reactiveAnomaly;
            return this;
        }

        public final void setReactiveAnomaly(ReactiveAnomaly.BuilderImpl reactiveAnomaly) {
            this.reactiveAnomaly = reactiveAnomaly != null ? reactiveAnomaly.build() : null;
        }

        @Override
        public DescribeAnomalyResponse build() {
            return new DescribeAnomalyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnomalyResponse> {
        public Builder proactiveAnomaly(ProactiveAnomaly var1);

        default public Builder proactiveAnomaly(Consumer<ProactiveAnomaly.Builder> proactiveAnomaly) {
            return this.proactiveAnomaly((ProactiveAnomaly)((ProactiveAnomaly.Builder)ProactiveAnomaly.builder().applyMutation(proactiveAnomaly)).build());
        }

        public Builder reactiveAnomaly(ReactiveAnomaly var1);

        default public Builder reactiveAnomaly(Consumer<ReactiveAnomaly.Builder> reactiveAnomaly) {
            return this.reactiveAnomaly((ReactiveAnomaly)((ReactiveAnomaly.Builder)ReactiveAnomaly.builder().applyMutation(reactiveAnomaly)).build());
        }
    }
}

