/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.Artifact;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;

public class ListArtifactsIterable
implements SdkIterable<ListArtifactsResponse> {
    private final DeviceFarmClient client;
    private final ListArtifactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListArtifactsIterable(DeviceFarmClient client, ListArtifactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListArtifactsResponseFetcher();
    }

    public Iterator<ListArtifactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Artifact> artifacts() {
        Function<ListArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.artifacts() != null) {
                return response.artifacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListArtifactsResponseFetcher
    implements SyncPageFetcher<ListArtifactsResponse> {
        private ListArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListArtifactsResponse nextPage(ListArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListArtifactsIterable.this.client.listArtifacts(ListArtifactsIterable.this.firstRequest);
            }
            return ListArtifactsIterable.this.client.listArtifacts((ListArtifactsRequest)((Object)ListArtifactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

