/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VerifyMode {
    POINT_IN_TIME_CONSISTENT("POINT_IN_TIME_CONSISTENT"),
    ONLY_FILES_TRANSFERRED("ONLY_FILES_TRANSFERRED"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VerifyMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerifyMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VerifyMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerifyMode> knownValues() {
        return Stream.of(VerifyMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

