/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3SnapshotAsset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3SnapshotAsset> {
    private static final SdkField<Double> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Size").getter(S3SnapshotAsset.getter(S3SnapshotAsset::size)).setter(S3SnapshotAsset.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double size;

    private S3SnapshotAsset(BuilderImpl builder) {
        this.size = builder.size;
    }

    public final Double size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SnapshotAsset)) {
            return false;
        }
        S3SnapshotAsset other = (S3SnapshotAsset)obj;
        return Objects.equals(this.size(), other.size());
    }

    public final String toString() {
        return ToString.builder((String)"S3SnapshotAsset").add("Size", (Object)this.size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3SnapshotAsset, T> g) {
        return obj -> g.apply((S3SnapshotAsset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double size;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SnapshotAsset model) {
            this.size(model.size);
        }

        public final Double getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Double size) {
            this.size = size;
            return this;
        }

        public final void setSize(Double size) {
            this.size = size;
        }

        public S3SnapshotAsset build() {
            return new S3SnapshotAsset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3SnapshotAsset> {
        public Builder size(Double var1);
    }
}

