/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataSetRequest
extends DataExchangeRequest
implements ToCopyableBuilder<Builder, GetDataSetRequest> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(GetDataSetRequest.getter(GetDataSetRequest::dataSetId)).setter(GetDataSetRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD));
    private final String dataSetId;

    private GetDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetId = builder.dataSetId;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSetRequest)) {
            return false;
        }
        GetDataSetRequest other = (GetDataSetRequest)((Object)obj);
        return Objects.equals(this.dataSetId(), other.dataSetId());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataSetRequest").add("DataSetId", (Object)this.dataSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataSetRequest, T> g) {
        return obj -> g.apply((GetDataSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeRequest.BuilderImpl
    implements Builder {
        private String dataSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSetRequest model) {
            super(model);
            this.dataSetId(model.dataSetId);
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataSetRequest build() {
            return new GetDataSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataSetRequest> {
        public Builder dataSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

