/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Code {
    ACCESS_DENIED_EXCEPTION("ACCESS_DENIED_EXCEPTION"),
    INTERNAL_SERVER_EXCEPTION("INTERNAL_SERVER_EXCEPTION"),
    MALWARE_DETECTED("MALWARE_DETECTED"),
    RESOURCE_NOT_FOUND_EXCEPTION("RESOURCE_NOT_FOUND_EXCEPTION"),
    SERVICE_QUOTA_EXCEEDED_EXCEPTION("SERVICE_QUOTA_EXCEEDED_EXCEPTION"),
    VALIDATION_EXCEPTION("VALIDATION_EXCEPTION"),
    MALWARE_SCAN_ENCRYPTED_FILE("MALWARE_SCAN_ENCRYPTED_FILE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Code(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Code fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Code.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Code> knownValues() {
        return Stream.of(Code.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

