/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Source {
    S3("S3"),
    DATA_CATALOG("DATA-CATALOG"),
    DATABASE("DATABASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Source(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Source fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Source.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Source> knownValues() {
        return Stream.of(Source.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

