/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TaskType {
    ARITHMETIC("Arithmetic"),
    FILTER("Filter"),
    MAP("Map"),
    MASK("Mask"),
    MERGE("Merge"),
    TRUNCATE("Truncate"),
    VALIDATE("Validate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TaskType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TaskType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskType> knownValues() {
        return Stream.of(TaskType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

