/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.SourceFlowConfig;
import software.amazon.awssdk.services.customerprofiles.model.Task;
import software.amazon.awssdk.services.customerprofiles.model.TasksCopier;
import software.amazon.awssdk.services.customerprofiles.model.TriggerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowDefinition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(FlowDefinition.getter(FlowDefinition::description)).setter(FlowDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowName").getter(FlowDefinition.getter(FlowDefinition::flowName)).setter(FlowDefinition.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowName").build()}).build();
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsArn").getter(FlowDefinition.getter(FlowDefinition::kmsArn)).setter(FlowDefinition.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsArn").build()}).build();
    private static final SdkField<SourceFlowConfig> SOURCE_FLOW_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceFlowConfig").getter(FlowDefinition.getter(FlowDefinition::sourceFlowConfig)).setter(FlowDefinition.setter(Builder::sourceFlowConfig)).constructor(SourceFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFlowConfig").build()}).build();
    private static final SdkField<List<Task>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tasks").getter(FlowDefinition.getter(FlowDefinition::tasks)).setter(FlowDefinition.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Task::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TriggerConfig> TRIGGER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TriggerConfig").getter(FlowDefinition.getter(FlowDefinition::triggerConfig)).setter(FlowDefinition.setter(Builder::triggerConfig)).constructor(TriggerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, FLOW_NAME_FIELD, KMS_ARN_FIELD, SOURCE_FLOW_CONFIG_FIELD, TASKS_FIELD, TRIGGER_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String flowName;
    private final String kmsArn;
    private final SourceFlowConfig sourceFlowConfig;
    private final List<Task> tasks;
    private final TriggerConfig triggerConfig;

    private FlowDefinition(BuilderImpl builder) {
        this.description = builder.description;
        this.flowName = builder.flowName;
        this.kmsArn = builder.kmsArn;
        this.sourceFlowConfig = builder.sourceFlowConfig;
        this.tasks = builder.tasks;
        this.triggerConfig = builder.triggerConfig;
    }

    public final String description() {
        return this.description;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final String kmsArn() {
        return this.kmsArn;
    }

    public final SourceFlowConfig sourceFlowConfig() {
        return this.sourceFlowConfig;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<Task> tasks() {
        return this.tasks;
    }

    public final TriggerConfig triggerConfig() {
        return this.triggerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.kmsArn(), other.kmsArn()) && Objects.equals(this.sourceFlowConfig(), other.sourceFlowConfig()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.triggerConfig(), other.triggerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"FlowDefinition").add("Description", (Object)this.description()).add("FlowName", (Object)this.flowName()).add("KmsArn", (Object)this.kmsArn()).add("SourceFlowConfig", (Object)this.sourceFlowConfig()).add("Tasks", this.hasTasks() ? this.tasks() : null).add("TriggerConfig", (Object)this.triggerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FlowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "KmsArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
            case "SourceFlowConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFlowConfig()));
            }
            case "Tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "TriggerConfig": {
                return Optional.ofNullable(clazz.cast(this.triggerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinition, T> g) {
        return obj -> g.apply((FlowDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String flowName;
        private String kmsArn;
        private SourceFlowConfig sourceFlowConfig;
        private List<Task> tasks = DefaultSdkAutoConstructList.getInstance();
        private TriggerConfig triggerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinition model) {
            this.description(model.description);
            this.flowName(model.flowName);
            this.kmsArn(model.kmsArn);
            this.sourceFlowConfig(model.sourceFlowConfig);
            this.tasks(model.tasks);
            this.triggerConfig(model.triggerConfig);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFlowName() {
            return this.flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        public final SourceFlowConfig.Builder getSourceFlowConfig() {
            return this.sourceFlowConfig != null ? this.sourceFlowConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        public final void setSourceFlowConfig(SourceFlowConfig.BuilderImpl sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig != null ? sourceFlowConfig.build() : null;
        }

        public final List<Task.Builder> getTasks() {
            List<Task.Builder> result = TasksCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tasks(Collection<Task> tasks) {
            this.tasks = TasksCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Task ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<Task.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (Task)((Task.Builder)Task.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<Task.BuilderImpl> tasks) {
            this.tasks = TasksCopier.copyFromBuilder(tasks);
        }

        public final TriggerConfig.Builder getTriggerConfig() {
            return this.triggerConfig != null ? this.triggerConfig.toBuilder() : null;
        }

        @Override
        public final Builder triggerConfig(TriggerConfig triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        public final void setTriggerConfig(TriggerConfig.BuilderImpl triggerConfig) {
            this.triggerConfig = triggerConfig != null ? triggerConfig.build() : null;
        }

        public FlowDefinition build() {
            return new FlowDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowDefinition> {
        public Builder description(String var1);

        public Builder flowName(String var1);

        public Builder kmsArn(String var1);

        public Builder sourceFlowConfig(SourceFlowConfig var1);

        default public Builder sourceFlowConfig(Consumer<SourceFlowConfig.Builder> sourceFlowConfig) {
            return this.sourceFlowConfig((SourceFlowConfig)((SourceFlowConfig.Builder)SourceFlowConfig.builder().applyMutation(sourceFlowConfig)).build());
        }

        public Builder tasks(Collection<Task> var1);

        public Builder tasks(Task ... var1);

        public Builder tasks(Consumer<Task.Builder> ... var1);

        public Builder triggerConfig(TriggerConfig var1);

        default public Builder triggerConfig(Consumer<TriggerConfig.Builder> triggerConfig) {
            return this.triggerConfig((TriggerConfig)((TriggerConfig.Builder)TriggerConfig.builder().applyMutation(triggerConfig)).build());
        }
    }
}

