/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Dimension {
    AZ("AZ"),
    INSTANCE_TYPE("INSTANCE_TYPE"),
    LINKED_ACCOUNT("LINKED_ACCOUNT"),
    LINKED_ACCOUNT_NAME("LINKED_ACCOUNT_NAME"),
    OPERATION("OPERATION"),
    PURCHASE_TYPE("PURCHASE_TYPE"),
    REGION("REGION"),
    SERVICE("SERVICE"),
    SERVICE_CODE("SERVICE_CODE"),
    USAGE_TYPE("USAGE_TYPE"),
    USAGE_TYPE_GROUP("USAGE_TYPE_GROUP"),
    RECORD_TYPE("RECORD_TYPE"),
    OPERATING_SYSTEM("OPERATING_SYSTEM"),
    TENANCY("TENANCY"),
    SCOPE("SCOPE"),
    PLATFORM("PLATFORM"),
    SUBSCRIPTION_ID("SUBSCRIPTION_ID"),
    LEGAL_ENTITY_NAME("LEGAL_ENTITY_NAME"),
    DEPLOYMENT_OPTION("DEPLOYMENT_OPTION"),
    DATABASE_ENGINE("DATABASE_ENGINE"),
    CACHE_ENGINE("CACHE_ENGINE"),
    INSTANCE_TYPE_FAMILY("INSTANCE_TYPE_FAMILY"),
    BILLING_ENTITY("BILLING_ENTITY"),
    RESERVATION_ID("RESERVATION_ID"),
    RESOURCE_ID("RESOURCE_ID"),
    RIGHTSIZING_TYPE("RIGHTSIZING_TYPE"),
    SAVINGS_PLANS_TYPE("SAVINGS_PLANS_TYPE"),
    SAVINGS_PLAN_ARN("SAVINGS_PLAN_ARN"),
    PAYMENT_OPTION("PAYMENT_OPTION"),
    AGREEMENT_END_DATE_TIME_AFTER("AGREEMENT_END_DATE_TIME_AFTER"),
    AGREEMENT_END_DATE_TIME_BEFORE("AGREEMENT_END_DATE_TIME_BEFORE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Dimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Dimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Dimension.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Dimension> knownValues() {
        return Stream.of(Dimension.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

