/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.QuickConnectSummary;

public class ListQueueQuickConnectsIterable
implements SdkIterable<ListQueueQuickConnectsResponse> {
    private final ConnectClient client;
    private final ListQueueQuickConnectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueueQuickConnectsIterable(ConnectClient client, ListQueueQuickConnectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListQueueQuickConnectsResponseFetcher();
    }

    public Iterator<ListQueueQuickConnectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QuickConnectSummary> quickConnectSummaryList() {
        Function<ListQueueQuickConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickConnectSummaryList() != null) {
                return response.quickConnectSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueueQuickConnectsResponseFetcher
    implements SyncPageFetcher<ListQueueQuickConnectsResponse> {
        private ListQueueQuickConnectsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueQuickConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueueQuickConnectsResponse nextPage(ListQueueQuickConnectsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueQuickConnectsIterable.this.client.listQueueQuickConnects(ListQueueQuickConnectsIterable.this.firstRequest);
            }
            return ListQueueQuickConnectsIterable.this.client.listQueueQuickConnects((ListQueueQuickConnectsRequest)((Object)ListQueueQuickConnectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

