/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReferenceType {
    URL("URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReferenceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReferenceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReferenceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReferenceType> knownValues() {
        return Stream.of(ReferenceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

