/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;

public class ListStoredQueriesIterable
implements SdkIterable<ListStoredQueriesResponse> {
    private final ConfigClient client;
    private final ListStoredQueriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStoredQueriesIterable(ConfigClient client, ListStoredQueriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStoredQueriesResponseFetcher();
    }

    public Iterator<ListStoredQueriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStoredQueriesResponseFetcher
    implements SyncPageFetcher<ListStoredQueriesResponse> {
        private ListStoredQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListStoredQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStoredQueriesResponse nextPage(ListStoredQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListStoredQueriesIterable.this.client.listStoredQueries(ListStoredQueriesIterable.this.firstRequest);
            }
            return ListStoredQueriesIterable.this.client.listStoredQueries((ListStoredQueriesRequest)((Object)ListStoredQueriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

