/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceValueType {
    RESOURCE_ID("RESOURCE_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceValueType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceValueType> knownValues() {
        return Stream.of(ResourceValueType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

