/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;

public class ListEventsDetectionJobsIterable
implements SdkIterable<ListEventsDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListEventsDetectionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventsDetectionJobsIterable(ComprehendClient client, ListEventsDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEventsDetectionJobsResponseFetcher();
    }

    public Iterator<ListEventsDetectionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEventsDetectionJobsResponseFetcher
    implements SyncPageFetcher<ListEventsDetectionJobsResponse> {
        private ListEventsDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventsDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventsDetectionJobsResponse nextPage(ListEventsDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEventsDetectionJobsIterable.this.client.listEventsDetectionJobs(ListEventsDetectionJobsIterable.this.firstRequest);
            }
            return ListEventsDetectionJobsIterable.this.client.listEventsDetectionJobs((ListEventsDetectionJobsRequest)((Object)ListEventsDetectionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

