/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPiiEntitiesDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListPiiEntitiesDetectionJobsResponse> {
    private static final SdkField<List<PiiEntitiesDetectionJobProperties>> PII_ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PiiEntitiesDetectionJobPropertiesList").getter(ListPiiEntitiesDetectionJobsResponse.getter(ListPiiEntitiesDetectionJobsResponse::piiEntitiesDetectionJobPropertiesList)).setter(ListPiiEntitiesDetectionJobsResponse.setter(Builder::piiEntitiesDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntitiesDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PiiEntitiesDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPiiEntitiesDetectionJobsResponse.getter(ListPiiEntitiesDetectionJobsResponse::nextToken)).setter(ListPiiEntitiesDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList;
    private final String nextToken;

    private ListPiiEntitiesDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.piiEntitiesDetectionJobPropertiesList = builder.piiEntitiesDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPiiEntitiesDetectionJobPropertiesList() {
        return this.piiEntitiesDetectionJobPropertiesList != null && !(this.piiEntitiesDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList() {
        return this.piiEntitiesDetectionJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPiiEntitiesDetectionJobPropertiesList() ? this.piiEntitiesDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPiiEntitiesDetectionJobsResponse)) {
            return false;
        }
        ListPiiEntitiesDetectionJobsResponse other = (ListPiiEntitiesDetectionJobsResponse)((Object)obj);
        return this.hasPiiEntitiesDetectionJobPropertiesList() == other.hasPiiEntitiesDetectionJobPropertiesList() && Objects.equals(this.piiEntitiesDetectionJobPropertiesList(), other.piiEntitiesDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPiiEntitiesDetectionJobsResponse").add("PiiEntitiesDetectionJobPropertiesList", this.hasPiiEntitiesDetectionJobPropertiesList() ? this.piiEntitiesDetectionJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PiiEntitiesDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.piiEntitiesDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPiiEntitiesDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListPiiEntitiesDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPiiEntitiesDetectionJobsResponse model) {
            super(model);
            this.piiEntitiesDetectionJobPropertiesList(model.piiEntitiesDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<PiiEntitiesDetectionJobProperties.Builder> getPiiEntitiesDetectionJobPropertiesList() {
            List<PiiEntitiesDetectionJobProperties.Builder> result = PiiEntitiesDetectionJobPropertiesListCopier.copyToBuilder(this.piiEntitiesDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder piiEntitiesDetectionJobPropertiesList(Collection<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList) {
            this.piiEntitiesDetectionJobPropertiesList = PiiEntitiesDetectionJobPropertiesListCopier.copy(piiEntitiesDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesDetectionJobPropertiesList(PiiEntitiesDetectionJobProperties ... piiEntitiesDetectionJobPropertiesList) {
            this.piiEntitiesDetectionJobPropertiesList(Arrays.asList(piiEntitiesDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesDetectionJobPropertiesList(Consumer<PiiEntitiesDetectionJobProperties.Builder> ... piiEntitiesDetectionJobPropertiesList) {
            this.piiEntitiesDetectionJobPropertiesList(Stream.of(piiEntitiesDetectionJobPropertiesList).map(c -> (PiiEntitiesDetectionJobProperties)((PiiEntitiesDetectionJobProperties.Builder)PiiEntitiesDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPiiEntitiesDetectionJobPropertiesList(Collection<PiiEntitiesDetectionJobProperties.BuilderImpl> piiEntitiesDetectionJobPropertiesList) {
            this.piiEntitiesDetectionJobPropertiesList = PiiEntitiesDetectionJobPropertiesListCopier.copyFromBuilder(piiEntitiesDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPiiEntitiesDetectionJobsResponse build() {
            return new ListPiiEntitiesDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPiiEntitiesDetectionJobsResponse> {
        public Builder piiEntitiesDetectionJobPropertiesList(Collection<PiiEntitiesDetectionJobProperties> var1);

        public Builder piiEntitiesDetectionJobPropertiesList(PiiEntitiesDetectionJobProperties ... var1);

        public Builder piiEntitiesDetectionJobPropertiesList(Consumer<PiiEntitiesDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

