/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.EntityTypesEvaluationMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognizerMetadataEntityTypesListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognizerMetadataEntityTypesListItem> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(EntityRecognizerMetadataEntityTypesListItem.getter(EntityRecognizerMetadataEntityTypesListItem::type)).setter(EntityRecognizerMetadataEntityTypesListItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<EntityTypesEvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationMetrics").getter(EntityRecognizerMetadataEntityTypesListItem.getter(EntityRecognizerMetadataEntityTypesListItem::evaluationMetrics)).setter(EntityRecognizerMetadataEntityTypesListItem.setter(Builder::evaluationMetrics)).constructor(EntityTypesEvaluationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_TRAIN_MENTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfTrainMentions").getter(EntityRecognizerMetadataEntityTypesListItem.getter(EntityRecognizerMetadataEntityTypesListItem::numberOfTrainMentions)).setter(EntityRecognizerMetadataEntityTypesListItem.setter(Builder::numberOfTrainMentions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrainMentions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EVALUATION_METRICS_FIELD, NUMBER_OF_TRAIN_MENTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final EntityTypesEvaluationMetrics evaluationMetrics;
    private final Integer numberOfTrainMentions;

    private EntityRecognizerMetadataEntityTypesListItem(BuilderImpl builder) {
        this.type = builder.type;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.numberOfTrainMentions = builder.numberOfTrainMentions;
    }

    public final String type() {
        return this.type;
    }

    public final EntityTypesEvaluationMetrics evaluationMetrics() {
        return this.evaluationMetrics;
    }

    public final Integer numberOfTrainMentions() {
        return this.numberOfTrainMentions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTrainMentions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerMetadataEntityTypesListItem)) {
            return false;
        }
        EntityRecognizerMetadataEntityTypesListItem other = (EntityRecognizerMetadataEntityTypesListItem)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.evaluationMetrics(), other.evaluationMetrics()) && Objects.equals(this.numberOfTrainMentions(), other.numberOfTrainMentions());
    }

    public final String toString() {
        return ToString.builder((String)"EntityRecognizerMetadataEntityTypesListItem").add("Type", (Object)this.type()).add("EvaluationMetrics", (Object)this.evaluationMetrics()).add("NumberOfTrainMentions", (Object)this.numberOfTrainMentions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "EvaluationMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluationMetrics()));
            }
            case "NumberOfTrainMentions": {
                return Optional.ofNullable(clazz.cast(this.numberOfTrainMentions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerMetadataEntityTypesListItem, T> g) {
        return obj -> g.apply((EntityRecognizerMetadataEntityTypesListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private EntityTypesEvaluationMetrics evaluationMetrics;
        private Integer numberOfTrainMentions;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerMetadataEntityTypesListItem model) {
            this.type(model.type);
            this.evaluationMetrics(model.evaluationMetrics);
            this.numberOfTrainMentions(model.numberOfTrainMentions);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final EntityTypesEvaluationMetrics.Builder getEvaluationMetrics() {
            return this.evaluationMetrics != null ? this.evaluationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder evaluationMetrics(EntityTypesEvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public final void setEvaluationMetrics(EntityTypesEvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        public final Integer getNumberOfTrainMentions() {
            return this.numberOfTrainMentions;
        }

        @Override
        public final Builder numberOfTrainMentions(Integer numberOfTrainMentions) {
            this.numberOfTrainMentions = numberOfTrainMentions;
            return this;
        }

        public final void setNumberOfTrainMentions(Integer numberOfTrainMentions) {
            this.numberOfTrainMentions = numberOfTrainMentions;
        }

        public EntityRecognizerMetadataEntityTypesListItem build() {
            return new EntityRecognizerMetadataEntityTypesListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognizerMetadataEntityTypesListItem> {
        public Builder type(String var1);

        public Builder evaluationMetrics(EntityTypesEvaluationMetrics var1);

        default public Builder evaluationMetrics(Consumer<EntityTypesEvaluationMetrics.Builder> evaluationMetrics) {
            return this.evaluationMetrics((EntityTypesEvaluationMetrics)((EntityTypesEvaluationMetrics.Builder)EntityTypesEvaluationMetrics.builder().applyMutation(evaluationMetrics)).build());
        }

        public Builder numberOfTrainMentions(Integer var1);
    }
}

