/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse;

public class ListIdentityPoolsIterable
implements SdkIterable<ListIdentityPoolsResponse> {
    private final CognitoIdentityClient client;
    private final ListIdentityPoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdentityPoolsIterable(CognitoIdentityClient client, ListIdentityPoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIdentityPoolsResponseFetcher();
    }

    public Iterator<ListIdentityPoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IdentityPoolShortDescription> identityPools() {
        Function<ListIdentityPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.identityPools() != null) {
                return response.identityPools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdentityPoolsResponseFetcher
    implements SyncPageFetcher<ListIdentityPoolsResponse> {
        private ListIdentityPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdentityPoolsResponse nextPage(ListIdentityPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityPoolsIterable.this.client.listIdentityPools(ListIdentityPoolsIterable.this.firstRequest);
            }
            return ListIdentityPoolsIterable.this.client.listIdentityPools((ListIdentityPoolsRequest)((Object)ListIdentityPoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

