/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse;

public class ListActionExecutionsPublisher
implements SdkPublisher<ListActionExecutionsResponse> {
    private final CodePipelineAsyncClient client;
    private final ListActionExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActionExecutionsPublisher(CodePipelineAsyncClient client, ListActionExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActionExecutionsPublisher(CodePipelineAsyncClient client, ListActionExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActionExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActionExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionExecutionDetail> actionExecutionDetails() {
        Function<ListActionExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionExecutionDetails() != null) {
                return response.actionExecutionDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActionExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListActionExecutionsResponseFetcher
    implements AsyncPageFetcher<ListActionExecutionsResponse> {
        private ListActionExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListActionExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActionExecutionsResponse> nextPage(ListActionExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListActionExecutionsPublisher.this.client.listActionExecutions(ListActionExecutionsPublisher.this.firstRequest);
            }
            return ListActionExecutionsPublisher.this.client.listActionExecutions((ListActionExecutionsRequest)((Object)ListActionExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

