/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Diagnostics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Diagnostics> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(Diagnostics.getter(Diagnostics::errorCodeAsString)).setter(Diagnostics.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> SCRIPT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptName").getter(Diagnostics.getter(Diagnostics::scriptName)).setter(Diagnostics.setter(Builder::scriptName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptName").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(Diagnostics.getter(Diagnostics::message)).setter(Diagnostics.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> LOG_TAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logTail").getter(Diagnostics.getter(Diagnostics::logTail)).setter(Diagnostics.setter(Builder::logTail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, SCRIPT_NAME_FIELD, MESSAGE_FIELD, LOG_TAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String scriptName;
    private final String message;
    private final String logTail;

    private Diagnostics(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.scriptName = builder.scriptName;
        this.message = builder.message;
        this.logTail = builder.logTail;
    }

    public final LifecycleErrorCode errorCode() {
        return LifecycleErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String scriptName() {
        return this.scriptName;
    }

    public final String message() {
        return this.message;
    }

    public final String logTail() {
        return this.logTail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptName());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Diagnostics)) {
            return false;
        }
        Diagnostics other = (Diagnostics)obj;
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.scriptName(), other.scriptName()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.logTail(), other.logTail());
    }

    public final String toString() {
        return ToString.builder((String)"Diagnostics").add("ErrorCode", (Object)this.errorCodeAsString()).add("ScriptName", (Object)this.scriptName()).add("Message", (Object)this.message()).add("LogTail", (Object)this.logTail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "scriptName": {
                return Optional.ofNullable(clazz.cast(this.scriptName()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "logTail": {
                return Optional.ofNullable(clazz.cast(this.logTail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Diagnostics, T> g) {
        return obj -> g.apply((Diagnostics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String scriptName;
        private String message;
        private String logTail;

        private BuilderImpl() {
        }

        private BuilderImpl(Diagnostics model) {
            this.errorCode(model.errorCode);
            this.scriptName(model.scriptName);
            this.message(model.message);
            this.logTail(model.logTail);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(LifecycleErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getScriptName() {
            return this.scriptName;
        }

        @Override
        public final Builder scriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public final void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogTail() {
            return this.logTail;
        }

        @Override
        public final Builder logTail(String logTail) {
            this.logTail = logTail;
            return this;
        }

        public final void setLogTail(String logTail) {
            this.logTail = logTail;
        }

        public Diagnostics build() {
            return new Diagnostics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Diagnostics> {
        public Builder errorCode(String var1);

        public Builder errorCode(LifecycleErrorCode var1);

        public Builder scriptName(String var1);

        public Builder message(String var1);

        public Builder logTail(String var1);
    }
}

